# R script for comparision of CASP1-GFP intensity between sides affected/unaffected by ablation


setwd("G:/My Drive/PhD/Paper with Peter/nice pictures/Ablation/Coordination/processed/")



# Data loading
library(readr)
library(dplyr)
library(ggplot2)

pre_abl_GFP <- read.csv("IntQuant_young_pre_GFP.csv")
pre_abl_PI  <- read.csv("IntQuant_young_pre_PI.csv")

post_abl_GFP <- read.csv("IntQuant_young_post_GFP.csv")
post_abl_PI  <- read.csv("IntQuant_young_post_PI.csv")

pre_abl_GFP$channel <- c("GFP")
pre_abl_GFP$condition <- c("pre")

pre_abl_PI$channel <- c("PI")
pre_abl_PI$condition <- c("pre")

post_abl_GFP$channel <- c("GFP")
post_abl_GFP$condition <- c("post")

post_abl_PI$channel <- c("PI")
post_abl_PI$condition <- c("post")

pre_abl_GFP <-  pre_abl_GFP %>%
  mutate(ratio = Y/max(Y))

pre_abl_PI <-  pre_abl_PI %>%
  mutate(ratio = Y/max(Y))

post_abl_GFP <-  post_abl_GFP %>%
  mutate(ratio = Y/max(Y))

post_abl_PI <-  post_abl_PI %>%
  mutate(ratio = Y/max(Y))



mydata_pre <- rbind(pre_abl_GFP, pre_abl_PI)
mydata_post <- rbind(post_abl_GFP, post_abl_PI)

mydata <- rbind(pre_abl_GFP, pre_abl_PI, post_abl_GFP, post_abl_PI)

colnames(mydata) <- c("X","Intensity", "channel", "condition", "ratio")
colnames(mydata_pre) <- c("X","Intensity", "channel", "condition", "ratio")
colnames(mydata_post) <- c("X","Intensity", "channel", "condition", "ratio")


plot(ratio~X, data = mydata_pre, type = "b")
plot(ratio~X, data = mydata_post, type = "b")



# plots
pdf("Ablation_intensity_young.pdf", useDingbats=FALSE, width = 5, height = 5)
ggplot(data = mydata_pre, aes(x=X, y=ratio, group = channel, col = channel))+
  geom_line(size = 1)+
  geom_point(size = 2.0)+
  theme_classic()+
  scale_color_manual(values = c("black", "red"))+
  ylim(0,1)+
  labs(x = "Distance [um]", y = "Relative fluorescence intensity")+
  theme(legend.position=c(0.9,0.8))

ggplot(data = mydata_post, aes(x=X, y=ratio, group = channel, col = channel))+
  geom_line(size = 1)+
  geom_point(size = 2.0)+
  theme_classic()+
  scale_color_manual(values = c("black", "red"))+
  ylim(0,1)+
  labs(x = "Distance [um]", y = "Relative fluorescence intensity")+
  #theme(legend.position="top")
  theme(legend.position=c(0.9,0.8))
  
dev.off()